<!doctype html>
<html class="no-js" lang="zxx">

<?php include('header.php');?>

<body>
    <header>
        <?php include('menu.php');?>
    </header>
    <div class="featured_candidates_area candidate_page_padding">
        <div class="container">
            <div class="row">
				<div class="col-lg-2"></div>
				<div class="col-lg-8">
					<div class="header">
						<h1 class="header__title"><i class="fas fa-wallet nav_menu_icon"></i> Finance</h1>
					</div>
					<!--PEN CONTENT-->
					<div class="content">
					  <!--content inner-->
					  <div class="content__inner">
						<!--tabs-->
						<div class="tabs">
						  <!--tabs navigation-->
						  <div class="tabs__nav">
							<ul class="tabs__nav-list">
							  <li class="noselect tabs__nav-item js-active" data-panel="deposit"><i class="fas fa-donate"></i> Deposit</li>
							  <li class="noselect tabs__nav-item" data-panel="withdraw"><i class="fas fa-share-square"></i> Withdraw</li>
							  <li class="noselect tabs__nav-item" data-panel="transactions"><i class="fas fa-table"></i> Transactions</li>
							</ul>
						  </div>
						  <!--tabs panels-->
						  <div class="tabs__panels">
							<!--single panel-->
							<div class="tabs__panel" id="deposit">
								<!--<center style="font-weight: bold; font-size: 14px">Your balance:</center>
								<div class="input-group user_balance"> 
									<span class="input-group-addon"><i class="fab fa-bitcoin"></i></span> 
									<div><?=number_format(($user_info->balance / 100000000), 8, '.', '')?> BTC</div>
								</div>-->
								<div style="text-align: center; margin: 20px auto; 0px; font-size: 15px; line-height: 20px; max-width: 600px;"> 
									You can send as many bitcoins as you would like to this address. The amount will be credited to your account after 2 network confirmations . We have no minimum deposit amount, we accept and credit all deposits to your account!
								</div> 
								<div id="qrcode" style="width:200px; height:200px; border: 5px solid #FFF; margin: 30px auto 0px;" title="otpauth://totp/23989@bitpick.io?secret=ODRVTHBDSS2JWQOP"></div>
								<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
									<span class="input-group-addon" style="border-radius: 0px; padding: 14px 13.5px"><i class="fas fa-wallet"></i></span>
									<input id="deposit_address" type="text" class="form-control" readonly="readonly" name="deposit_address" style="height: 45px; background: #FFF; font-size: 14px" value="<?=$deposit_address?>"> 
									<span class="input-group-addon" style="color: #2196f3; border-radius: 0px; padding: 12px 12.5px; border-left: none; border-right: 1px solid #DDD; cursor: pointer; font-size: 16px"><i class="fas fa-copy"></i></span> 
								</div> 
								<p style="text-align: center; margin: 20px auto; 0px; font-size: 14px; line-height: 20px; max-width: 600px; font-style: italic"> 
									*Your deposit will be credited after 1 confirmation(s)
								</p> 
							</div>
							<!--single panel-->
							<div class="tabs__panel" id="withdraw">
								<!--<center style="font-weight: bold; font-size: 14px">Your balance:</center>
								<div class="input-group user_balance"> 
									<span class="input-group-addon"><i class="fab fa-bitcoin"></i></span> 
									<div><?=number_format(($user_info->balance / 100000000), 8, '.', '')?> BTC</div>
								</div>-->
								<div style="text-align: center; margin: 20px auto; 0px; font-size: 15px; line-height: 20px; max-width: 600px;"> 
									Transaction fee will be automatically calculated according to whether you want the withdrawal order to be instant or slow! Minimum withdrawal amount: 0.00030000 BTC. We have no maximum withdrawal. You can withdraw the entire balance in your account.
								</div> 
								<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
									<span class="input-group-addon" style="border-radius: 0px; padding: 14px 16.5px"><i class="fas fa-wallet"></i></span> 
									<input id="withdrawal_address" type="text" class="form-control" name="withdrawal_address" onchange="process_show_withdrawal_label()" placeholder="Bitcoin address" style="height: 45px;">
									<!--<span class="input-group-addon" style="color: #2196f3; border-radius: 0px; padding: 12px 12.5px; border-left: none; border-right: 1px solid #DDD; cursor: pointer; font-size: 16px"><i class="fas fa-address-book"></i></span>-->
								</div>
								<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
									<span class="input-group-addon" style="border-radius: 0px; padding: 14px 16px"><i class="fab fa-bitcoin"></i></span> 
									<input id="withdrawal_amount" type="number" class="form-control" name="withdrawal_amount" placeholder="Amount" style="height: 45px;">
								</div> 
								<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
									<span class="input-group-addon" style="border-radius: 0px; padding: 14px 14px"><i class="fas fa-tags"></i></span>
									<input id="withdrawal_label" type="text" class="form-control" name="withdrawal_label" placeholder="Label (Optional)" style="height: 45px; color: #4caf50">
								</div>
								<?php if($user_info->enable_2fa):?>
								<div class="input-group" style="margin: 20px auto 0px; height: 45px; font-size: 14px; max-width: 600px;"> 
									<span class="input-group-addon" style="border-radius: 0px; padding: 14px 15.5px"><i class="fas fa-keyboard"></i></span> 
									<input id="withdrawal_2fa_code" type="number" class="form-control" name="withdrawal_2fa_code" placeholder="Enter 2FA Code" style="height: 45px;">
								</div>
								<?php endif?>
								<div class="input-group" style="margin: 20px auto 40px; height: 45px; width: 100%; max-width: 600px;"> 
									<input type="submit" id="process_withdraw_bitcoin" onclick="process_withdraw_bitcoin()" class="btn btn-success" value="Withdraw" style="height: 45px; width: 100%; font-size: 14px;">
								</div>
								
								<?php if(!$user_info->enable_2fa):?>
								<center style="font-weight: bold; font-size: 14px">You currently do not have 2FA enabled</center>
								<div class="input-group" style="margin: 5px auto 0px; height: 45px; width: 100%; max-width: 600px;">
									<input type="submit" class="btn btn-info" value="Enable 2FA" style="height: 45px; width: 100%; font-size: 14px;">
								</div>
								<?php endif?>
							</div>
							<!--single panel-->
							<div class="tabs__panel" id="transactions">
								<!--<center style="font-weight: bold; font-size: 14px">Your balance:</center>
								<div class="input-group user_balance"> 
									<span class="input-group-addon"><i class="fab fa-bitcoin"></i></span> 
									<div><?=number_format(($user_info->balance / 100000000), 8, '.', '')?> BTC</div>
								</div>-->
								<div style="max-width: 120px">
								<select onchange="load_user_transactions()" id="load_transactions_by_page_id">
									<?php for($i = 1; $i <= $number_pages; $i++):?>
									<option value="<?=$i?>">Page <?=$i?></option>
									<?php endfor?>
								</select>
								</div>
								<table class="table table-striped" style="min-width: 550px">
									<thead>
										<tr>
											<th scope="col">Time</th>
											<th scope="col">Type</th>
											<th scope="col">Address</th>
											<th scope="col">Amount</th>
											<th scope="col">Status</th>
										</tr>
									</thead>
									<tbody id="user_transactions"></tbody>
								</table>
							</div>
						  </div>
						</div>
					  </div>
					</div>	
				</div>
				<div class="col-lg-2"></div>
			</div>
		 </div>
	</div>
    <?php include('footer.php');?>
	<script>
	
		var load_requests_page_id;
		
		var qrcode = new QRCode("qrcode", {
			text:"<?=$deposit_address?>",
			width:200,
			height:200,
			colorDark:"#000000",
			colorLight:"#ffffff",
			correctLevel:QRCode.CorrectLevel.H
		});
		
		function process_withdraw_bitcoin() {
			$("#process_withdraw_bitcoin").attr("disabled", !0);
			var withdrawal_address = $('#withdrawal_address').val();
			var withdrawal_amount = $('#withdrawal_amount').val();
			var withdrawal_label = $('#withdrawal_label').val();
			
			$.ajax({
				url: "<?=base_url()?>process.php",
				type: "POST",
				data: "action=withdraw_bitcoin&withdrawal_address="+withdrawal_address+"&withdrawal_amount="+withdrawal_amount+"&withdrawal_label="+withdrawal_label,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						Swal.fire('Error!',obj.mes,'error');
					} else {
						var current_balance = parseFloat($('.user_balance div').text()) * 100000000;
						$('.user_balance div').text(parseFloat((current_balance - parseInt(obj.amount)) / 100000000).toFixed(8)+' BTC');
						load_user_transactions();
						Swal.fire('Success!',obj.mes,'success');
					}
					$("#process_withdraw_bitcoin").attr("disabled", false);
				}
			});
		}
		
		function process_show_withdrawal_label() {
			var withdrawal_address = $('#withdrawal_address').val();
			$.ajax({
				url: "<?=base_url()?>process.php",
				type: "POST",
				data: "action=show_withdrawal_label&withdrawal_address="+withdrawal_address,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 1) {
						$('#withdrawal_label').val(obj.label);
					} else {
						$('#withdrawal_label').val('');
					}
				}
			});
		}
		
		function load_user_transactions() {
			var page_id = parseInt($('#load_transactions_by_page_id').val());
			$.ajax({
				url: "<?=base_url()?>load.php",
				type: "POST",
				data: "data=user_transactions&page_id="+page_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					obj = JSON.parse(out);
					if(obj.ret == 0) {
						Swal.fire('Error!',obj.mes,'error');
					} else {
						if(obj.data != null && obj.data.length > 0) {
							var requests = '';
							for(i = 0; i < obj.data.length; i++) {
								if(obj.data[i].type == 'Deposit') {
									obj.data[i].type = '<span style="color: #4caf50">Deposit</span>';
								} else if (obj.data[i].type == 'Withdrawal') {
									obj.data[i].type = '<span style="color: #ff9800">Withdrawal</span>';
								}
								obj.data[i].address = '<a style="color: #2196f3" target="_blank" href="https://www.blockchain.com/vi/btc/address/'+obj.data[i].address+'">'+obj.data[i].address.substr(0, 4)+'***'+obj.data[i].address.substr(-4)+'</a>';
								if (obj.data[i].status == 'Unconfirmed') {
									obj.data[i].status = '<span style="color: #333">Unconfirmed</span> | <span style="color: #ff5722; cursor: pointer" onclick="process_cancel_request('+obj.data[i].id+')">Cancel</span>';
								} else if(obj.data[i].status == 'Pending') {
									obj.data[i].status = '<span style="color: #03a9f4">Pending</span> | <span style="color: #ff5722; cursor: pointer" onclick="process_cancel_request('+obj.data[i].id+')">Cancel</span>';
								} else if (obj.data[i].status == 'Completed') {
									obj.data[i].status = '<span style="color: #4caf50">Completed</span>';
								} else if (obj.data[i].status == 'Processing') {
									obj.data[i].status = '<span style="color: #03a9f4">Processing</span>';
								} else if (obj.data[i].status == 'Canceled') {
									obj.data[i].status = '<span style="color: #999">Canceled</span>';
								} 
								requests += '<tr><td>'+obj.data[i].time+'</td><td>'+obj.data[i].type+'</td><td>'+obj.data[i].address+'</td><td>'+obj.data[i].amount+'</td><td>'+obj.data[i].status+'</td></tr>';
							}
							$('#user_transactions').html(requests);
						} else {
							if(page_id == 1) {
								$('#user_transactions').html('<tr><td colspan="5" style="text-algin: center; background: #FFF; padding: 20px 10px"><center><img src="img/bored_cat.png" style="width: 150px; margin: 10px"></center><p style="font-size: 15px; text-align: center; font-style: italic">No transaction record.</p></td></tr>');
							} else {
								$('#user_transactions').append('<tr><td colspan="5" style="text-algin: center; background: #FFF; padding: 20px 10px"><p style="font-size: 15px; text-align: center; font-style: italic">No transaction record.</p></td></tr>');
							}
						}
					}
				}
			});
		}
		
		function process_cancel_request(request_id) {
			Swal.fire({
				title: 'Are you sure?',
				text: "Do you want to cancel this request!",
				icon: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#8bc34a',
				cancelButtonColor: '#d33',
				confirmButtonText: 'Yes',
				cancelButtonText: 'No',
			}).then((result) => {
				if (result.value) {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=cancel_request&request_id="+request_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								Swal.fire('Error!',obj.mes,'error');
							} else {
								var current_balance = parseFloat($('.user_balance div').text()) * 100000000;
								$('.user_balance div').text(parseFloat((current_balance + parseInt(obj.amount)) / 100000000).toFixed(8)+' BTC');
								load_user_transactions();
								Swal.fire('Success!',obj.mes,'success');
							}
							
						}
					});
				}
			});
		}
		
		$(document).ready(function() {
			load_user_transactions();
		});
		
	</script>
</body>

</html>